<?php
// Caminho da pasta original
$origem = __DIR__ . '/site';

// Novas pastas que serão criadas com cópia do conteúdo da pasta original
$novasPastas = ['precos', 'masculino', 'feminino', 'whatsapp', 'contato', 'localizacao', 'telefone', 'fotos'];

// Função para copiar recursivamente uma pasta e seu conteúdo
function copiarPasta($origem, $destino) {
    if (!is_dir($origem)) {
        echo "A pasta de origem não existe: $origem\n";
        return false;
    }

    if (!file_exists($destino)) {
        mkdir($destino, 0755, true);
    }

    $itens = scandir($origem);

    foreach ($itens as $item) {
        if ($item == '.' || $item == '..') continue;

        $origemItem = $origem . '/' . $item;
        $destinoItem = $destino . '/' . $item;

        if (is_dir($origemItem)) {
            copiarPasta($origemItem, $destinoItem);
        } else {
            copy($origemItem, $destinoItem);
        }
    }

    return true;
}

// Execução do processo de cópia
foreach ($novasPastas as $pasta) {
    $destino = __DIR__ . '/' . $pasta;
    if (copiarPasta($origem, $destino)) {
        echo "✔️ Pasta '$pasta' criada com sucesso.\n";
    } else {
        echo "❌ Falha ao criar a pasta '$pasta'.\n";
    }
}
?>
