<?php
// Defina aqui as substituições (uma vez só, para todas as páginas)
$substituicoes = [
    'akitel' => '11111111',
    'nomesite' => 'nomesite',
    'akisite' => '/',
    'xxx' => 'KSMVXC9Q'
];

// Caminho da pasta original
$origem = __DIR__ . '/site';

// Novas pastas que serão criadas
$novasPastas = ['precos', 'masculino', 'feminino', 'whatsapp', 'contato', 'localizacao', 'telefone', 'fotos'];

// Função para copiar recursivamente
function copiarPasta($origem, $destino) {
    if (!is_dir($origem)) {
        echo "A pasta de origem não existe: $origem\n";
        return false;
    }
    
    if (!file_exists($destino)) {
        mkdir($destino, 0755, true);
    }
    
    $itens = scandir($origem);
    
    foreach ($itens as $item) {
        if ($item == '.' || $item == '..') continue;
        
        $origemItem = $origem . '/' . $item;
        $destinoItem = $destino . '/' . $item;
        
        if (is_dir($origemItem)) {
            copiarPasta($origemItem, $destinoItem);
        } else {
            copy($origemItem, $destinoItem);
        }
    }
    
    return true;
}

// PASSO 1: Substituir no index.html da pasta original /site
echo "=== SUBSTITUINDO VARIÁVEIS NO INDEX.HTML ORIGINAL ===\n";
$indexOriginal = $origem . '/index.html';

if (file_exists($indexOriginal)) {
    $conteudo = file_get_contents($indexOriginal);
    
    foreach ($substituicoes as $buscar => $substituir) {
        $conteudo = str_replace($buscar, $substituir, $conteudo);
        echo "Substitudo: $buscar  $substituir\n";
    }
    
    file_put_contents($indexOriginal, $conteudo);
    echo " Variáveis substituídas em /site/index.html\n\n";
} else {
    echo "❌ Arquivo /site/index.html não encontrado!\n\n";
    exit;
}

// PASSO 2: Copiar a pasta /site para as novas pastas
echo "=== COPIANDO PASTA /site PARA AS NOVAS PASTAS ===\n";
foreach ($novasPastas as $pasta) {
    $destino = __DIR__ . '/' . $pasta;
    
    if (copiarPasta($origem, $destino)) {
        echo "✔️ Pasta '$pasta' criada com sucesso.\n";
    } else {
        echo "❌ Falha ao criar a pasta '$pasta'.\n";
    }
}

echo "\n=== PROCESSO CONCLUÍDO ===\n";
?>